/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.IndexPlugin;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexUtil {
    public static <T extends JSON.Convertible> List<T> createList(Object object, Class<T> itemClass) {
        ArrayList<JSON.Convertible> result = null;
        if (itemClass != null && object != null) {
            List objects;
            if (object.getClass().isArray()) {
                Object[] objects2 = (Object[])object;
                if (objects2.length > 0) {
                    result = new ArrayList<JSON.Convertible>(objects2.length);
                    try {
                        Object[] objectArray = objects2;
                        int n = objects2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object value = objectArray[n2];
                            if (value instanceof Map) {
                                JSON.Convertible v = (JSON.Convertible)itemClass.newInstance();
                                v.fromJSON((Map)value);
                                result.add(v);
                            }
                            ++n2;
                        }
                    }
                    catch (InstantiationException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                }
            } else if (object instanceof List && (objects = (List)object).size() > 0) {
                result = new ArrayList();
                try {
                    for (Object value : objects) {
                        if (!(value instanceof Map)) continue;
                        JSON.Convertible v = (JSON.Convertible)itemClass.newInstance();
                        v.fromJSON((Map)value);
                        result.add(v);
                    }
                }
                catch (InstantiationException e) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public static List<String> createList(Object object) {
        List<String> result = null;
        if (object != null) {
            Collection<Object> objects = null;
            if (object.getClass().isArray()) {
                objects = Arrays.asList((Object[])object);
            } else if (object instanceof Collection) {
                objects = (Collection)object;
            }
            if (!CollectionsUtil.isEmpty(objects)) {
                return CollectionsUtil.map(objects, (IMap)new IMap<Object, String>(){

                    public String map(Object item) {
                        return item.toString();
                    }
                });
            }
        }
        return result;
    }

    public static Set<IFileStore> getAllFiles(IFileStore file, IProgressMonitor monitor) {
        HashSet<IFileStore> files;
        block16: {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            files = new HashSet<IFileStore>(0);
            try {
                if (file == null) {
                    HashSet<IFileStore> hashSet = files;
                    return hashSet;
                }
                IFileInfo info = file.fetchInfo(0, (IProgressMonitor)sub.newChild(1));
                if (!info.exists()) {
                    HashSet<IFileStore> hashSet = files;
                    return hashSet;
                }
                if (info.isDirectory()) {
                    Object[] fileList;
                    block15: {
                        fileList = file.childStores(0, (IProgressMonitor)sub.newChild(2));
                        if (!ArrayUtil.isEmpty((Object[])fileList)) break block15;
                        HashSet<IFileStore> hashSet = files;
                        return hashSet;
                    }
                    try {
                        Object[] objectArray = fileList;
                        int n = fileList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            files.addAll(IndexUtil.getAllFiles((IFileStore)child, (IProgressMonitor)sub.newChild(7)));
                            ++n2;
                        }
                        break block16;
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    }
                    break block16;
                }
                Set set = CollectionsUtil.newSet((Object[])new IFileStore[]{file});
                return set;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            finally {
                sub.done();
            }
        }
        return files;
    }

    private IndexUtil() {
    }
}

